@extends('laravelinstaller::layouts.master-verify')

@section('template_title')
    {{ __('Verify License') }}
@endsection

@section('title')
    <i class="fa fa-key fa-fw" aria-hidden="true"></i>
    {{ __('Verify License') }}
@endsection

@section('container')
    <form method="post" action="{{ route('LaravelVerifier::licenseVerify') }}">
        <input type="hidden" name="_token" value="{{ csrf_token() }}">
        <div class="form-group {{ $errors->has('license_code') ? ' has-error ' : '' }}">
            <label for="license_code">
                {{ __('License Code') }}
            </label>
            <input type="text" name="license_code" id="license_code" value="" placeholder="{{ __('License Code') }}"
                required>
            @if ($errors->has('license_code'))
                <span class="error-block">
                    <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                    {{ $errors->first('license_code') }}
                </span>
            @endif
        </div>

        <div class="buttons">
            <button class="button" type="submit">
                {{ __('Verify License') }}
            </button>
        </div>
    </form>
@endsection
