<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\User\OrderController;
use App\Http\Controllers\AiChatController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
 */

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/auto-topup/webhook', [OrderController::class, 'auto_verify'])->name('auto.topup.webhook');

// AI Chat Routes (Grouped under prefix)
Route::prefix('ai-chat')->group(function () {
    // Main chat endpoint
    Route::post('/', [AiChatController::class, 'chat'])
        ->middleware(['throttle:30,1']) // Adjusted throttle to 30 req/min
        ->name('ai.chat');

    // Health check / status endpoint
    Route::get('/status', function () {
        return response()->json([
            'status' => 'active',
            'timestamp' => now()->toISOString(),
            'openai_configured' => !empty(config('openai.api_key')),
            'analysis_enabled' => true,
            'website_url' => 'https://ffgameshop.com',
            'features' => [
                'real_time_analysis',
                'intent_detection',
                'content_extraction',
                'dynamic_responses',
            ]
        ]);
    });

    // Debug/testing endpoint — available only in local environment
    Route::get('/test-analysis/{message}', function ($message) {
        if (app()->environment('local')) {
            $controller = new AiChatController();
            $reflection = new \ReflectionClass($controller);
            $method = $reflection->getMethod('performRealTimeWebsiteAnalysis');
            $method->setAccessible(true);

            try {
                $analysis = $method->invoke($controller, $message);
                return response()->json($analysis);
            } catch (\Exception $e) {
                return response()->json(['error' => $e->getMessage()], 500);
            }
        }

        return response()->json(['error' => 'Not available in production'], 403);
    });
});
