<script>
$(document).ready(function() {
    function createAndShowModal(url, image_url, content, button_text) {
        const modalHtml = `
            <div id="popup" class="modal fade" tabindex="-1" role="dialog" align="center">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content" style="border-radius:6px; overflow:visible; border:none; position:relative; padding-bottom:60px;">

                        <!-- Image -->
                        ${image_url ? `<img src="${image_url}" class="img-fluid w-100" style="display:block; width:100%; border-top-left-radius:6px; border-top-right-radius:6px;">` : ''}

                        <!-- Content -->
                        <div class="modal-body" style="padding:15px; text-align:left; margin-top:10px;">
                            ${content ? `<div style="font-weight:bold; font-size:15px; color:#000; margin-bottom:15px;">${content}</div>` : ''}

                            <!-- Blue Button -->
                            ${url ? `<div style="text-align:left; margin-top:10px;">
                                        <a class="btn theme-btn" href="${url}" 
                                           style="background:#1a73e8; color:#fff; font-weight:600; border-radius:6px; padding:8px 15px; font-size:14px; text-decoration:none;">
                                           ${button_text}
                                        </a>
                                     </div>` : ''}
                        </div>

                        <!-- Close Button -->
                        <div style="position:absolute; bottom:-20px; left:50%; transform:translateX(-50%);">
                            <button type="button" class="btn" data-bs-dismiss="modal"
                                style="background: {{ $settings->theme_color }}; color:#fff; font-weight:bold; border:2px solid #fff; border-radius:20px; padding:10px 20px; min-width:140px;">
                                ✘ CLOSE
                            </button>
                        </div>

                    </div>
                </div>
            </div>
        `;
        const modal = $(modalHtml);
        $('body').append(modal);

        // Show modal (only close button will close it, backdrop click or ESC won't work)
        modal.modal({
            backdrop: 'static',
            keyboard: false
        });
        modal.modal('show');
    }

    function fetchPopups() {
        const popupRoute = '{{ route('popup') }}';

        fetch(popupRoute)
            .then(response => {
                if (!response.ok) {
                    throw new Error(`Error fetching popups from ${popupRoute}: ${response.statusText}`);
                }
                return response.json();
            })
            .then(data => {
                const popups = data.popups;
                popups.forEach(popup => {
                    createAndShowModal(popup.url, popup.image_url, popup.content, popup.button_text);
                });
            })
            .catch(error => {
                console.error('Error fetching popups:', error.message);
            });
    }

    fetchPopups();
});
</script>