<?php

namespace App\Services\TopupProvider;

use App\Constants\OrderStatus;
use App\Constants\Status;
use App\Jobs\VerifyOrderStatus;
use App\Models\Voucher;
use App\Models\Variation;
use App\Models\Shell;
use App\Services\TopupProvider\TopupProviderService;
use Exception;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class FreeFire extends TopupProviderService
{
    public function placeOrder(?Voucher $autoVoucher = null)
    {
        try {
            $shell = Shell::find($this->order->product->shell_id);
            $payload = [
                'orderid' => $this->order->id,
                'playerid' => $this->order->account_info['player_id'],
                'pacakge' => (string) $this->order->variation->provider_product_id,
                'url' => route('auto.topup.webhook'),
                'domain' => request()->getHost(),
            ];

            if ($autoVoucher) {
                $payload['code'] = $this->getCode($autoVoucher->code);
            } else {
                $payload['code'] = "shell";
                $payload['username'] = $shell->username;
                $payload['password'] = $shell->password;
                $payload['autocode'] = $shell->autocode;
                $payload['shell_balance'] = $shell->shellbalance;
                $payload['tgbotid'] = $shell->tgbotid;
            }
            $response = Http::withHeaders(
                [
                    'Content-Type'  => 'application/json',
                ]
            )->post(gs()->free_fire_server_url, $payload);

            if ($response->successful()) {
                
            } else {
                $this->order->voucher_code = null;
                $this->order->status = OrderStatus::PROCESSING;
                $this->order->save();

                if($autoVoucher) {
                    $autoVoucher->order_id = null;
                    $autoVoucher->status = Status::AVAILABLE;
                    $autoVoucher->save();
                    $v_id = Variation::where('product_id', gs()->unipin_product_id)->where('provider_product_id', $this->order->variation->provider_product_id)->first();
                    $v_id->stock += 1;
                    $v_id->save();
                }
            }
        } catch (Exception $e) {
            \Log::error('Auto Order: ' . $e->getMessage());
        }
    }

    private function getCodeType($code)
    {
         if (is_array($code)) {
        $code = $code[0]; 
    }
        $prefix = substr($code, 0, 4);

        if ($prefix === 'UPBD') {
            return 2;
        } elseif ($prefix === 'BDMB') {
            return 1;
        } else {
            return 0;
        }
    }

    private function getCode($code)
    {
         if (is_array($code)) {
        $code = $code[0]; 
    }
        return $code;
    }
}
