<?php

namespace App\Http\Controllers\Auth;

use App\Models\User;
use Illuminate\View\View;
use Illuminate\Http\Request;
use Illuminate\Validation\Rules;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\RedirectResponse;
use Illuminate\Auth\Events\Registered;
use App\Providers\RouteServiceProvider;
use Symfony\Component\Mailer\Exception\TransportException;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create(): View
    {
        return view('auth.register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'name' => ['required', 'string', 'min:5', 'max:255', 'unique:'.User::class],
            'email' => ['required', 'string', 'lowercase', 'email', 'max:255', 'unique:'.User::class],
            'phone' => ['required', 'string', 'max:11', 'unique:'.User::class],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
            'terms' => ['required', 'accepted']
        ]);
        
        $firstWord = explode(" ", trim($request->name))[0]; 
        $firstLetter = strtoupper(substr($firstWord, 0, 1));
        $profilePicture = "https://ui-avatars.com/api/?name=" . urlencode($firstLetter) . "&size=96&background=f29f2c";

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'password' => Hash::make($request->password),
            'avator' => $profilePicture,
        ]);

        try {
            if(!empty(gs()->smtp_host)){
                event(new Registered($user));
            }
        } catch (TransportException $e) {
            //
        }

        Auth::login($user);

        return redirect(RouteServiceProvider::HOME);
    }
}
