<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ShellResource\Pages;
use App\Filament\Resources\ShellResource\RelationManagers;
use App\Models\Shell;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ShellResource extends Resource
{
    protected static ?string $model = Shell::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    
    protected static ?string $navigationGroup = 'Products';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Select::make('name')
                    ->options([
                        'MY' => 'MY SHELL',
                        'SG' => 'SINGAPORE SHELL',
                        'SR' => 'SRILANKA',
                        'ID' => 'INDONESIA SHELL',
                    ])->required(),
                TextInput::make('username')
                    ->label('User Name')
                    ->required(),
                TextInput::make('password')
                    ->label('Password')
                    ->required(),
                TextInput::make('autocode')
                    ->label('Authentication Code')
                    ->required(),
                TextInput::make('shellbalance')
                    ->label('Shell Balance')
                    ->required(),
                TextInput::make('tgbotid')
                    ->label('Telegram Bot ID')
                    ->required(),
                TextInput::make('server')
                    ->label('Server Url')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('id')
                    ->sortable()
                    ->searchable()
                    ->toggleable(),
                TextColumn::make('name')
                    ->sortable()
                    ->searchable()
                    ->toggleable(),
                TextColumn::make('username')
                    ->sortable()
                    ->searchable()
                    ->toggleable(),
                TextColumn::make('password')
                    ->sortable()
                    ->searchable()
                    ->toggleable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListShells::route('/'),
          //  'create' => Pages\CreateShell::route('/create'),
            'edit' => Pages\EditShell::route('/{record}/edit'),
        ];
    }
}
