document.addEventListener("DOMContentLoaded", function () {
    const button = document.getElementById('check-username');
    const uidField = document.getElementById('player_id');

    if (button && uidField) {
        button.addEventListener('click', function handler() {
            const uid = uidField.value.trim();

            if (!uid) {
                button.textContent = '⚠️ প্রথমে আপনার UID লিখুন';
                button.style.backgroundColor = 'red';
                return;
            }

         
            button.style.pointerEvents = "none";
            // ✅ Loading animation (spinner + text)
            button.innerHTML = `
                <span class="loading-spinner" 
                      style="display:inline-block;width:18px;height:18px;border:3px solid #fff;border-top:3px solid #00702a;
                      border-radius:50%;animation:spin 0.8s linear infinite;vertical-align:middle;margin-right:6px;">
                </span>Checking...`;
            button.style.backgroundColor = '#00702a';
button.style.pointerEvents = "none";
            // 🔄 Spinner animation
            const style = document.createElement('style');
            style.innerHTML = `
            @keyframes spin {
                0% { transform: rotate(0deg); }
                100% { transform: rotate(360deg); }
            }`;
            document.head.appendChild(style);

            fetch('/check-username?uid=' + uid)
                .then(res => res.json())
                .then(response => {
                    if (response && response.status === 200 && !response.error) {
                      
                        button.textContent = ' ' + response.data.username;
                        button.style.backgroundColor = '#00702a';
                        button.style.pointerEvents = "none"; 
                    } else {
                        button.textContent = 'আপনার গেম আইডির নাম চেক করুন';
                        button.style.backgroundColor = '#00702a';
                        button.style.pointerEvents = "auto";
                    }
                })
                .catch(() => {
                    button.textContent = '⚠️ সার্ভারে সমস্যা হয়েছে';
                    button.style.backgroundColor = 'red';
                    button.style.pointerEvents = "auto";
                });
        });
    }
});